// Multi Parameter.js

var parameters = [];
var targetType = -1;
var ignores = ["rotorder", "activePolySelection", "locked", 
               "shear", "prefrot", "postrot", "prerot"]; // you can modify these parameters.
var checkRequired = ["position", "rotation", "scale", "pivot"];
var prefix = "p.";

function buildUI( tool ) {

    var doc = tool.document();
    var obj = doc.selectedObject();

    if (obj && obj.owner() != undefined) {
        targetType = obj.type();

        tool.addParameterSeparator("Properties of "+obj.getParameter("name"));

        var parameterCount = obj.parameterCount();

        for (var i = 0;i < parameterCount;i++) {
            var parameter = obj.parameterAtIndex(i);

            if (parameter.name() == 'activeuvset' && obj.type() != POLYGONOBJ) continue;

            if (ignores.indexOf( parameter.name() ) == -1 ) {

                if (checkRequired.indexOf( parameter.name() ) != -1) {
                    tool.addParameterBool("set."+parameter.name(), 0, 0, 1, false, false);
                }

                switch( parameter.type() ) {
                    case INT_PARAMETER:
                        tool.addParameterInt(prefix+parameter.name(), obj.getParameter(parameter.name()), -10000, 10000, false, false);
                        parameters.push( { "type": parameter.type() , "name": parameter.name() } );
                        break;
                    case FLOAT_PARAMETER:
                        tool.addParameterFloat(prefix+parameter.name(), obj.getParameter(parameter.name()), -10000.0, 10000.0, false, false);
                        parameters.push( { "type": parameter.type() , "name": parameter.name() } );
                        break;
                    case BOOL_PARAMETER:
                        tool.addParameterBool(prefix+parameter.name(), obj.getParameter(parameter.name()), 0, 1, false, false);
                        parameters.push( { "type": parameter.type() , "name": parameter.name() } );
                        break;
                    case VEC3D_PARAMETER:
                        var vec = obj.getParameter(parameter.name());
                        tool.addParameterFloat(prefix+parameter.name()+'.x', vec.x, -10000, 10000, false, false);
                        tool.addParameterFloat(prefix+parameter.name()+'.y', vec.y, -10000, 10000, false, false);
                        tool.addParameterFloat(prefix+parameter.name()+'.z', vec.z, -10000, 10000, false, false);
                        parameters.push( { "type": parameter.type() , "name": parameter.name() } );
                }
            }
        }

        tool.addParameterSeparator("Set");
        tool.addParameterLink("target", false);
        tool.addParameterSelector("mode", ["target children only", "target and children", "target only", "all"], false, false);
        tool.addParameterButton("apply", "apply", "applyParameters");

        /*
        for(var i in parameters) {
            print( parameters[i].name + ':' + parameters[i].type );
        }
         */
    } else {

        OS.messageBox( "Base object is not detected.", "You should select base object at Object Browser, when this script is invoked.");

    }
}

function applyParameters( tool ) {
    var doc = tool.document();

    var mode = tool.getParameter("mode");

    try {

        switch( mode ) {
            case 0: // target children only
                var target = tool.getParameter("target");
                if (!target) throw("target error");
                setParameterForObj( target, tool, mode, 0 );
                break;
            case 1: // target and children
                var target = tool.getParameter("target");
                if (!target) throw("target error");
                setParameterForObj( target, tool, mode, 0 );
                break;
            case 2: // target only
                var target = tool.getParameter("target");
                if (!target) throw("target error");
                setParameterForObj( target, tool, mode, 0 );
                break;
            case 3: // all
                var target = doc.root();
                setParameterForObj( target, tool, mode, 0 );
                break;
        }
    } catch( e ) {
        if (e == "target error") OS.messageBox("Property 'target' is not set", "This mode requires 'target' object.");
        else throw(e);
    }
}

function setParameterForObj( obj, tool, mode, level ) {

    if (mode != 2) {
        var childCount = obj.childCount();
        for(var i = 0;i < childCount;i++) {
            var child = obj.childAtIndex(i);
            setParameterForObj( child, tool, mode, level + 1 );
        }
    }

    //print( "set for:" + obj.getParameter("name") + ", level:" + level );
    
    if (mode == 0 && level == 0) return;
    if (mode == 3 && level == 0) return;

    if (obj && obj.type() == targetType) {
        // for undoable
        obj.recordParametersForUndo();

        for (var i = 0;i < parameters.length;i++) {
            var info = parameters[i];
            var parameter_obj = obj.parameterWithName( info.name );

            try {

                if ((checkRequired.indexOf( info.name ) != -1 && tool.getParameter("set."+info.name)) || checkRequired.indexOf( info.name ) == -1) {

                    if (parameter_obj && parameter_obj.type() == info.type) { // check parameter
                        switch( info.type ) {
                            case INT_PARAMETER:
                            case FLOAT_PARAMETER:
                            case BOOL_PARAMETER:
                                obj.setParameter( info.name, tool.getParameter( prefix + info.name ) );
                                break;
                            case VEC3D_PARAMETER:
                                var vec = new Vec3D( tool.getParameter( prefix + info.name + '.x' ),
                                                     tool.getParameter( prefix + info.name + '.y' ),
                                                     tool.getParameter( prefix + info.name + '.z' ) );
                                obj.setParameter( info.name, vec );
                                break;
                        }
                    }

                }

            } catch(e) {

                print( e.line + ':' + e.message );

            }
        }

    } else if (obj) {

        // print( "    type is not match." );

    }
}